package fr.asip.cps3.exemple.vues.ecrans.resultats;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JTextField;

import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.ecrans.Ecran;

/**
 * Classe permettant de modliser un cran de sortie
 */
public abstract class Sortie extends Ecran {

	/**
	 * Libell du champ Opration 
	 */
	protected JLabel libelleOperation;
	
	/**
	 * Texte du champ Opration
	 */
	protected JTextField texteOperation;
	
	/**
	 * Libell du champ retour
	 */
	protected JLabel libelleRetour;
	
	/**
	 * Texte du champ retour
	 */
	protected JTextField texteRetour;	
	
	
	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran
	 */
	public Sortie(FenetrePrincipale fenetre) {

		super(fenetre);
		
		libelleOperation = new JLabel("Opration : ");
		libelleRetour = new JLabel("Retour : ");
    	texteOperation = new JTextField();
    	texteRetour = new JTextField();
    	texteOperation.setEditable(false);
    	texteRetour.setEditable(false);
    	texteOperation.setBackground(Color.white);
    	texteRetour.setBackground(Color.white);
		
	}

	/**
     * Affecte le texte de l'opration
     * @param operation Le texte de l'opration
     */
	public void setOperation(String operation) {
		if(texteOperation != null)
			texteOperation.setText(operation);
	}

	/**
	 * Affecte le texte du retour
	 * @param retour Le texte du retour
	 */
	public void setRetour(String retour) {
		if(texteRetour != null)
			texteRetour.setText(retour);		
	}

	/**
	 * Affecte le texte du retour
	 * @param codeRetour Le texte du retour
	 */
	public void setRetour(long codeRetour) {
		if(texteRetour != null)
			texteRetour.setText(TraitementsUtil.retranscritCodeRetour(codeRetour));		
	}	
	
}
